' ------------------------------------------------------------------------ '
'  @@ Usage                                      *** BASIC Version ***     '
'                                                                          '
'  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   '
'                                                                          '
'   FUNCTION LOADDRV% (szDrvName$)                                         '
'                                                                          '
'   DESCRIPTION:                                                           '
'       Loads driver into memory with the driver name specified. The       '
'       driver is always loaded to the offset 0 of a segement.             '
'                                                                          '
'   ENTRY:                                                                 '
'       szDrvName :- Driver name to be loaded.                             '
'                                                                          '
'   EXIT:                                                                  '
'       Segment of the loaded driver if successfull, else returns 0        '
'                                                                          '
' ------------------------------------------------------------------------ '

FUNCTION LOADDRV% (szDrvName$)

    DIM szDrvFile$, Handle%, dwFileLen&, wDrvSeg%


    LOADDRV% = 0

    ' search SOUND environment for driver
    szDrvFile$ = ENVIRON$("SOUND")

    IF (szDrvFile$ <> "") THEN
        szDrvFile$ = szDrvFile$ + "\DRV\" + szDrvName$

        IF (FINDFILE%(szDrvFile$) = 0) THEN
            szDrvFile$ = ""
        ENDIF
    ENDIF

    ' search the current directory for driver
    IF (szDrvFile$ = "") THEN
        szDrvFile$ = szDrvName$
    ENDIF

    IF (FINDFILE%(szDrvFile$) <> 0) THEN
        Handle% = DOSOPEN%(szDrvFile$)

        IF (Handle% <> 0) THEN
            dwFileLen& = FILESIZE(Handle%)

            wDrvSeg% = ALLOCMEM(INT((dwFileLen& + 15) / 16))

            IF (wDrvSeg% <> 0) THEN
                IF DOSREAD%(Handle%, INT(0), wDrvSeg%, dwFileLen&) THEN
                    LOADDRV% = wDrvSeg%
                ENDIF
            ENDIF

            DOSCLOSE(Handle%)
        ELSE
            PRINT "Error in opening " + szDrvFile$
        ENDIF
    ELSE
        PRINT "Driver file " + szDrvName$ + " does not exist ..."
    ENDIF

END FUNCTION
